<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hologram Chatbot Besar</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            background-color: #000;
            overflow: hidden;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        /* Container Hologram Diperbesar */
        .hologram-container {
            position: relative;
            width: 450px;  /* Diperbesar dari 300px */
            height: 450px; /* Diperbesar dari 300px */
        }

        .face {
            position: absolute;
            width: 100%;
            height: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .face img {
            width: 100%; /* Gambar dimaksimalkan jadi besar */
            height: auto;
            object-fit: contain;
        }

        /* --- PENGATURAN ROTASI (DIBALIK SESUAI GAMBAR ANDA) --- */
        
        /* Atas: Kepala Menghadap Atas (Kaki di tengah) */
        .top {
            top: -100%;
            left: 0;
            transform: rotate(0deg); 
        }

        /* Bawah: Kepala Menghadap Bawah (Kaki di tengah) */
        .bottom {
            bottom: -100%;
            left: 0;
            transform: rotate(180deg);
        }

        /* Kiri: Kepala Menghadap Kiri (Kaki di tengah) */
        .left {
            top: 0;
            left: -100%;
            transform: rotate(-90deg);
        }

        /* Kanan: Kepala Menghadap Kanan (Kaki di tengah) */
        .right {
            top: 0;
            right: -100%;
            transform: rotate(90deg);
        }

        /* Titik tengah untuk menaruh piramida */
        .center-marker {
            position: absolute;
            top: 50%; left: 50%;
            width: 20px; height: 20px;
            background: rgba(0, 0, 0, 0); /* Transparan */
            border: 1px dashed red; /* Garis bantu merah (bisa dihapus) */
            transform: translate(-50%, -50%);
            z-index: 10;
        }
    </style>
</head>
<body>

    <div class="hologram-container">
        <div class="face top"><img id="img-top" src="nico.png"></div>
        <div class="face bottom"><img id="img-bottom" src="nico.png"></div>
        <div class="face left"><img id="img-left" src="nico.png"></div>
        <div class="face right"><img id="img-right" src="nico.png"></div>
        
        <div class="center-marker"></div>
    </div>

    <script>
        // KONFIGURASI NAMA FILE GAMBAR
        const IMG_DIAM = "nico.png";         // Gambar Diam
        const IMG_BICARA = "nicobot.gif";     // Gambar Bergerak (GIF)

        // Variabel untuk menyimpan status terakhir agar tidak reload terus
        let lastStatus = ""; 

        // Fungsi untuk mengganti gambar
        function updateImages(isTalking) {
            const src = isTalking ? IMG_BICARA : IMG_DIAM;
            
            // Tambahkan cache buster (timestamp) HANYA jika beralih ke GIF
            // Ini memaksa browser memutar GIF dari awal saat baru mulai bicara
            // Tapi tidak me-reload saat sedang bicara.
            // Gunakan timestamp jika GIF macet, jika lancar hapus bagian '?t=...'
            const finalSrc = src; 

            document.getElementById('img-top').src = finalSrc;
            document.getElementById('img-bottom').src = finalSrc;
            document.getElementById('img-left').src = finalSrc;
            document.getElementById('img-right').src = finalSrc;
        }

        // --- SETUP SSE (Realtime Listener) ---
        if (!!window.EventSource) {
            var source = new EventSource('stream.php');

            source.onmessage = function(event) {
                try {
                    // Cek jika data kosong
                    if (!event.data || event.data === "{}") return;

                    var data = JSON.parse(event.data);
                    
                    // --- PERBAIKAN UTAMA DI SINI ---
                    // Cek apakah status BERUBAH dari sebelumnya?
                    // Jika status sama (misal: sebelumnya talking, sekarang talking lagi), JANGAN LAKUKAN APAPAUN.
                    // Ini membiarkan GIF berputar sampai selesai tanpa di-cut.
                    
                    if (data.sensor !== lastStatus) {
                        console.log("Status Berubah: " + lastStatus + " -> " + data.sensor);
                        lastStatus = data.sensor; // Simpan status baru

                        if (data.sensor === "talking") {
                            updateImages(true);
                        } else {
                            updateImages(false);
                        }
                    }

                } catch (e) {
                    console.error("Error parsing JSON", e);
                }
            };

            source.onerror = function(e) {
                console.log("SSE Error, reconnecting...");
            };
        } else {
            alert("Browser Anda tidak mendukung fitur ini.");
        }
    </script>

</body>
</html>